--

function mainpatch()
    slusdirent = cdutil:findpath "/SLPS_031.47;1" or error "This is not a SuperRobotWarAlphaGaiden Japanese CD."
    
    iso:foreword(cdutil)
    pvd = createpvd(cdutil)
    pvd.volid = "SRWAG-US"

    root = iso:setbasics(pvd)
    
    root:setbasicsxa()
    root:fromdir(cdutil:findpath "/")
    
    for i, d in ipairs(game_dirtree) do
      if (d.contents ~= nil) then
        -- we have a dir containing files
        print("Processing directory " .. d.name)
        direntry = findpath("/" .. d.name)
        curdir = iso:createdir(root, d.name, 1, direntry)
        for j, sd in ipairs(d.contents) do
          if (type(sd) == "table") then
            print("Reinserting subfile " .. d.name .. "/" .. sd.name)
            direntry = cdutil:findpath("/" .. d.name .. "/" .. sd.name .. ";1")
            iso:createfile(curdir, sd.name, Input(sd.file), direntry)
          else
            print("Processing subfile " .. d.name .. "/" .. sd)
            direntry = cdutil:findpath("/" .. d.name .. "/" .. sd .. ";1")
            if (direntry:isxastr()) then
              print "File is XA/STR stream."
              iso:createfile(curdir, sd, cdutil:cdfile(direntry.Sector, direntry.Size * 2336 / 2048, MODE2), direntry, MODE2)
            else
              iso:createfile(curdir, sd, cdutil:cdfile(direntry), direntry)
            end
          end
        end
      else
        -- single file in root
        print("Processing file " .. d.name)
        direntry = cdutil:findpath("/" .. d.name .. ";1")
        -- iso:createfile(root, d.name, cdutil:cdfile(direntry)):fromdir(direntry)
        iso:createfile(root, d.name, Input(d.file), direntry)

        -- if (type(d) == "table") then
        --   print("Reinserting file " .. d.name)
        --   direntry = cdutil:findpath("/" .. d.name .. ";1")
        --   iso:createfile(root, d.name, Input(d.file), direntry)
        -- else
        --   print("Processing file " .. d.name)
        --   direntry = cdutil:findpath("/" .. d.name .. ";1")
        --   iso:createfile(root, d.name, cdutil:cdfile(direntry)):fromdir(direntry)
        -- end
          
      end
    end
    
    print "Padding and closing iso..."
    
    falsesect = {}

    for k = 1, 148, 1 do
	iso:createsector(falsesect, MODE2)
    end

    iso:close()

    print "Everything's done!"
end

game_dirtree = {
  { ["name"] = "AI", ["contents"] = {
    "AI_GAI.BIN" } },

  { ["name"] = "BATTLE", ["contents"] = {
    { ["name"] = "AUTO01.BSL", ["file"] = "PATCHFILES\\BATTLE\\AUTO01.BSL" },
    { ["name"] = "AUTO02.BSL", ["file"] = "PATCHFILES\\BATTLE\\AUTO02.BSL" },
    "BATTLE.WAC",
    "BGDATA.BIN",
    { ["name"] = "BXCLIST.BIN", ["file"] = "PATCHFILES\\BATTLE\\BXCLIST.BIN" },
    "COMMON.BIN",
    { ["name"] = "KARAOKE.BSL", ["file"] = "PATCHFILES\\BATTLE\\KARAOKE.BSL" },
    "UNIT.BIN",
    "WPBANLST.BIN",
    "WPTIMLST.BIN" } },

  { ["name"] = "BGM", ["contents"] = {
    "BGMLIST1.BIN",
    "BGMLIST2.BIN",
    "BGMLIST3.BIN",
    "BGMLIST4.BIN",
    "BGMLIST5.BIN" } },

  { ["name"] = "BUSTUP", ["contents"] = {
    "BACK.BIN",
    "CHARA.BIN",
    "H.BIN",
    "MAP.BIN",
    { ["name"] = "SCRIPT.BIN", ["file"] = "PATCHFILES\\BUSTUP\\SCRIPT.BIN" } } },

  { ["name"] = "FONTWIN", ["contents"] = {
    "12F.DAT",
    "8FONT_R.TIM",
    "ACTFORM.BIN",
    "BANPRE.TIM",
    "BANPRE_B.TIM",
    "CPYLGT_B.TIM",
    "CPYLGT_L.TIM",
    "FPACK.BIN",
    "GB8BIT.TIM",
    "HARO.TIM",
    "HEROFACE.TIM",
    "IMBG.BIN",
    "ROGO.TIM",
    "ROGOBACK.TIM",
    "START_1.TIM",
    "TITLEDAT.BIN",
    "WINDATAB.DAT",
    "WINDATAE.DAT",
    "WINDATAI.DAT",
    "WINDATAM.DAT",
    "WINDATAO.DAT",
    "WINDOW.TIM",
    { ["name"] = "WINTEX.BIN", ["file"] = "PATCHFILES\\FONTWIN\\WINTEX.BIN" } } },

  { ["name"] = "OPTION", ["contents"] = {
    "DC.BIN",
    "DC.DAT",
    "DR.BIN",
    { ["name"] = "KA.BIN", ["file"] = "PATCHFILES\\OPTION\\KA.BIN" },
    "OPT.TIM",
    { ["name"] = "SS.BIN", ["file"] = "PATCHFILES\\OPTION\\SS.BIN" } } },

  { ["name"] = "OVL", ["contents"] = {
    { ["name"] = "BTL_GRP.BIN", ["file"] = "PATCHFILES\\OVL_31\\BTL_GRP.BIN" },
    { ["name"] = "CMA1_GRP.BIN", ["file"] = "PATCHFILES\\OVL_31\\CMA1_GRP.BIN" },
    "CMA2_GRP.BIN",
    { ["name"] = "COMM_GRP.BIN", ["file"] = "PATCHFILES\\OVL_31\\COMM_GRP.BIN" },
    "DUMMY.BIN",
    "ENDS_GRP.BIN",
    "END_GRP.BIN",
    "ENTR_GRP.BIN",
    { ["name"] = "IMIS_GRP.BIN", ["file"] = "PATCHFILES\\OVL_31\\IMIS_GRP.BIN" },
    "MOVE_GRP.BIN",
    "MPWP_GRP.BIN",
    { ["name"] = "PRM_GRP.BIN", ["file"] = "PATCHFILES\\OVL_31\\PRM_GRP.BIN" },
    "PRO_GRP.BIN",
    { ["name"] = "SNDM_GRP.BIN", ["file"] = "PATCHFILES\\OVL_31\\SNDM_GRP.BIN" },
    { ["name"] = "SNDU_GRP.BIN", ["file"] = "PATCHFILES\\OVL_31\\SNDU_GRP.BIN" },
    { ["name"] = "SNMP_GRP.BIN", ["file"] = "PATCHFILES\\OVL_31\\SNMP_GRP.BIN" },
    { ["name"] = "TITL_GRP.BIN", ["file"] = "PATCHFILES\\OVL_31\\TITL_GRP.BIN" } } },

  { ["name"] = "PRO", ["contents"] = {
    "GENDAI2.TIM",
    { ["name"] = "GKANJI0.TIM", ["file"] = "PATCHFILES\\PRO\\GKANJI0.TIM" },
    { ["name"] = "GKANJI1.TIM", ["file"] = "PATCHFILES\\PRO\\GKANJI1.TIM" },
    "MIRAI.TIM" } },

  { ["name"] = "SLPS_031.47", ["file"] = "PATCHFILES\\SLPS_031.47" },
  { ["name"] = "SYSTEM.CNF", ["file"] = "PATCHFILES\\SYSTEM_031.CNF" },

  { ["name"] = "UNITPRAM", ["contents"] = {
    { ["name"] = "PARAC.BIN", ["file"] = "PATCHFILES\\UNITPRAM\\PARAC.BIN" },
    { ["name"] = "PILOT.BIN", ["file"] = "PATCHFILES\\UNITPRAM\\PILOT.BIN" },
    { ["name"] = "ROBOT.RAF", ["file"] = "PATCHFILES\\UNITPRAM\\ROBOT.RAF" } } },

  { ["name"] = "SE", ["contents"] = {
    "SELIST.BIN" } },

  { ["name"] = "SNMAP", ["contents"] = {
    "BAN_BTL.BIN",
    "BAN_COM.BIN",
    "BAN_DEF.BIN",
    "BAN_ENTR.BIN",
    "BAN_TR.BIN",
    "BZDATA.BIN",
    "CHNGJ.BIN",
    { ["name"] = "DEADMESS.BIN", ["file"] = "PATCHFILES\\SNMAP\\DEADMESS.BIN" },
    { ["name"] = "EM.BIN", ["file"] = "PATCHFILES\\SNMAP\\EM.BIN" },
    "ENLIST.BIN",
    "KIEFETIM.BIN",
    "MAPEFE.BIN",
    "MAPWEPXA.BIN",
    { ["name"] = "MDATA.BIN", ["file"] = "PATCHFILES\\SNMAP\\MDATA.BIN" },
    "MTIM.BIN",
    "MW.BIN",
    "OVER.BIN",
    "SNDATA.BIN",
    "SNMFLOW.BIN",
    { ["name"] = "SNMSG.BIN", ["file"] = "PATCHFILES\\SNMAP\\SNMSG.BIN" },
    "SPEFE.BIN",
    "TRBOX.BIN",
    "TRMESS.BIN",
    "UTIM0.BIN",
    "UTIM1.BIN",
    "UTIM2.BIN",
    "UTIM3.BIN",
    "UTIM4.BIN" } },

 { ["name"] = "TITLE", ["contents"] = {
   { ["name"] = "SUBTITLE.BIN", ["file"] = "PATCHFILES\\TITLE\\SUBTITLE.BIN" },
   { ["name"] = "TITLEANM.BIN", ["file"] = "PATCHFILES\\TITLE\\TITLEANM.BIN" },
   { ["name"] = "TITLETEX.BIN", ["file"] = "PATCHFILES\\TITLE\\TITLETEX.BIN" } } },

 { ["name"] = "XA", ["contents"] = {
   "OPENING2.XA",
   "TEST.XA" } },

 { ["name"] = "XSTR", ["contents"] = {
   "MV1.STR",
   "MV2.STR",
   "MV3.STR",
   "MV4.STR",
   "MV5.STR" } }
}
